Running multiple redirectors at the same time can increase the resiliency of our C2 comms.  Right now, our Beacon is talking to a single IP, **10.10.5.39**.  I know this is a closed lab, but imagine that is a public IP backed by a domain name, e.g. acmecorp.uk.

If our target blocks that IP and/or domain, we lose our Beacon.  We can simulate this on WKSTN-1 by adding a block rule to the Windows Firewall.

![[12. C2 Resiliency.png]]

If this happens your Beacons are pretty much lost for good, because you can't communicate with them and ask them to Beacon to a different location.  We must plan for this eventuality ahead of time.  To that end we have **Redirector 2** in the lab, which has been preconfigured with a similar Apache setup discussed thus far.

Use the same username and SSH key to create an identical SSH tunnel from Kali, then go back to the listener configuration in Cobalt Strike and add Redirector 2's IP address into the HTTP hosts field.  There's also a host rotation strategy that we can change.  There are four main categories:

-   **round-robin**:  use each host (top-to-bottom) in a loop.
-   **random**:  select a random host each time.
-   **failover**:  use a host until the consecutive failover count is reached, then move onto the next.
-   **rotate**:  use each host for the specified length of time, then move onto the next.

![[13. C2 Resiliency.png]]

Pick the best strategy depending on your operational needs.  You may even choose to run multiple Team Servers with listeners configured with different rotation strategies to support short-haul and long-haul C2.

Remove the currently hosted payload and regenerate a new one for it to get the new listener config.  Disable the Windows Firewall rule on WKSTN-1 (so that it's no longer blocking) and execute the new payload.  Once the new Beacon is checking in, re-enable that firewall rule and the check-ins will stop as before.  The check-in time on this profile is 5 seconds, so 5 consecutive failures will take 5 x 5 = 25 seconds.  After 30 seconds (25 plus the next sleep cycle), you should see the Beacon reappear.

